# ArchitectOS v0.2.0

ArchitectOS is an AI-native development and remediation framework designed to
provide a safe, deterministic bridge between human developers, LLM reasoning,
and a real operating system environment.

This release establishes a formal runtime layout for AOS and separates project
code from AOS operational state. It includes:

- A dedicated AOS runtime home: `~/.architectos/`
- Updated `aos-chat` client using the new directory structure
- Updated RAG subsystem (`aos_rag.py`) using the new AOS_HOME path
- A generic cleanup utility: `tools/aos_cleanup.py`
- New versioning structure and release documentation

## Runtime Layout (AOS_HOME)

AOS uses a dedicated runtime directory:

```
~/.architectos/
    chats/             # conversation logs
    logs/commands/     # AOS-RUN execution logs
    data/aos_rag.db    # RAG memory database
    config/            # (future) policies, model router, etc.
```

## Project Layout

Your project code and tools remain in the working directory (for example):

```
~/ArchitectOS/
    bin/aos-chat
    tools/aos_rag.py
    tools/aos_cleanup.py
    ...
```

## Feature Highlights in v0.2.0

- AOS runtime decoupled from project directory
- Improved RAG indexing with automatic context-size fallback
- Generic cleanup utility with TUI menu
- Stable tool primitives:
  - `AOS-RUN`
  - `AOS-WRITE`
  - `AOS-READ`
- Safety model based on OS-level ACLs instead of custom tool restrictions
- Improved system prompt guidance (clarified tool usage rules)

## Basic Usage

1. Ensure `OPENAI_API_KEY` is set in your environment.
2. Optionally set `AOS_HOME` (defaults to `~/.architectos`):

   ```bash
   export AOS_HOME="$HOME/.architectos"
   ```

3. Run the chat client from your project root:

   ```bash
   python3 bin/aos-chat
   ```

## Rebuilding RAG Memory

From your project root (where `tools/aos_rag.py` lives):

```bash
python3 tools/aos_rag.py index-commands /path/to/your/logs/commands
python3 tools/aos_rag.py index-files . --kind script --ext .py .rb
```

The RAG database will be stored in:

```bash
~/.architectos/data/aos_rag.db
```

## Cleanup Utility

The cleanup helper is generic and can be reused on any dev project tree:

```bash
python3 tools/aos_cleanup.py --root /path/to/your/project
```

It provides an interactive menu to remove build artifacts, venvs, old logs,
and RAG DB files.

## License

License for this project is not yet finalized. Treat this tarball as
experimental and internal-only for now.
