# ArchitectOS Roadmap

This is intentionally lightweight for v0.1.0. The priority is **getting prior art
and a working skeleton into the world**, then iterating.

## v0.1.0 — "Spec & Skeleton"

- [x] Name the system **ArchitectOS (AOS)**.
- [x] Define a minimal, readable repository layout.
- [x] Provide a human‑readable **whitepaper**.
- [x] Implement a very small **CLI** (`aos`) in bash + Python.
- [x] Support reading a `project.yml` and validating basic structure.
- [x] Add a **validation pipeline** that can run commands like `php -l`.
- [x] Provide a concrete example (`examples/wp_rescue/project.yml`).

## v0.2.0 — "Tighter LLM Loop"

- [ ] Define a simple, stable **JSON protocol** for LLM <-> AOS.
- [ ] Add `aos run <project> <pipeline>` and structured JSON logs.
- [ ] Add `aos diff` helpers for summarizing file changes.
- [ ] Provide example front‑end glue for ChatGPT / aichat.

## v0.3.0 — "Multi‑language & Sandboxing"

- [ ] Add richer tool abstractions (Python, Node, PHP, Docker, etc.).
- [ ] Add optional containerized execution (e.g. via Docker or Podman).
- [ ] Add per‑project **allowlists** for commands and environment access.

## v0.4.0+ — "Real Dev Workflows"

- [ ] Integrate with Git (branch creation, stash, patch application).
- [ ] Support multi‑step **build graphs** with dependencies.
- [ ] Provide templates for common stacks (Laravel, WordPress, Django, etc.).
- [ ] Add quality‑of‑life commands (`aos doctor`, `aos init`, `aos wizard`).

This file is deliberately brief. The real detail lives in your own projects and specs.
