# ArchitectOS (AOS) — v0.1.0

ArchitectOS (AOS) is a **human-in-the-loop operating system for LLM‑driven software projects**.

Instead of copy‑pasting ad‑hoc code snippets from a model into a live codebase, AOS gives you:

- A **project spec** (`project.yml`) that defines what the model is allowed to touch.
- A **toolchain description** so the model can talk about builds, tests, and validation.
- A **thin CLI** (`aos`) that runs **real tools** (php, pytest, git, etc.) and **feeds results back** to the model.
- A **sandboxed scratch tree** for generated code and experiments.
- A **repeatable build pipeline** that can be inspected, diffed, and rolled back.

This repo is a **starter skeleton**: it is intentionally small, readable, and easy to extend.  
The goal is to give you something you can actually run today while we iterate on the deeper architecture.

> Status: **experimental / proof of concept**. Expect breaking changes.

---

## Quick start

```bash
# 1. Put this folder somewhere sane
tar xzf architectos-0.1.0.tar.gz
cd architectos-0.1.0

# 2. Make the CLI executable
chmod +x aos

# 3. See what AOS thinks it can do
./aos help
./aos spec
./aos validate examples/wp_rescue
```

The default commands are intentionally simple:

- `aos help` — show commands and philosophy.
- `aos spec` — pretty‑print one or more project specs and sanity‑check them.
- `aos validate <project-dir>` — run the project's configured sanity checks (e.g. `php -l`, `pytest`, etc.).
- `aos plan <project-dir>` — (stub) emit a high‑level plan JSON the LLM can reason about.
- `aos run <project-dir> <step>` — (stub) execute a named build/test step from the spec.

You are expected to **wire this into an LLM front‑end** (ChatGPT, aichat, custom UI, etc.) and let the model
reason about:

- which files to create or edit;
- which steps to run (`lint`, `test`, `build`);
- how to interpret the logs that AOS returns.

AOS itself stays **dumb, deterministic, and inspectable**.

---

## Repository layout

```text
architectos-0.1.0/
├── aos                     # CLI entrypoint (bash + Python shim)
├── aoslib/
│   ├── __init__.py
│   ├── core.py             # Core helpers for loading specs & running commands
│   ├── project.py          # ProjectSpec model & validation
│   └── util.py             # Small utilities
├── docs/
│   ├── whitepaper.md       # Conceptual overview / "prior art"
│   └── roadmap.md          # High-level roadmap
├── examples/
│   └── wp_rescue/
│       └── project.yml     # Example spec for a WordPress rescue toolkit
├── README.md
└── LICENSE                 # Placeholder (choose your license)
```

---

## Project spec (high level)

AOS expects each project to have a `project.yml` that looks roughly like this:

```yaml
name: "WordPress Rescue Toolkit"
id: "wp-rescue"
version: "0.1.0"

paths:
  root: "/var/www/example.com"
  scratch: "./.aos-scratch"
  include:
    - "rescuewp/**"
  exclude:
    - "node_modules/**"
    - "vendor/**"

tools:
  php_lint:
    cmd: "php"
    args: ["-l"]
    file_globs:
      - "rescuewp/**/*.php"

pipelines:
  sanity:
    - step: "php-lint"
      tool: "php_lint"
      files_from: "php_lint"
```

The LLM never runs arbitrary shell commands: it reasons **within this spec** and uses the CLI as its hands.

---

## Next steps

- Wire `aos` into your LLM workflow as a **trusted executor**.
- Extend `examples/wp_rescue/project.yml` to match your real directories.
- Add more tools and pipelines (e.g. `composer test`, `npm test`, `pytest`, `phpunit`).
- Commit everything to Git and iterate.

For conceptual details, see [`docs/whitepaper.md`](docs/whitepaper.md).

---

## License

`LICENSE` in this bundle is a placeholder. For an early personal / research project you might choose:

- **Apache‑2.0** if you want commercial friendliness and patent language.
- **GPL‑3.0** if you want improvements to remain open.
- **AGPL‑3.0** if you're worried about SaaS vendors keeping changes private.

Pick whatever fits your goals, then replace the placeholder file.
