import json
import sys
from pathlib import Path

def eprint(*args, **kwargs):
    print(*args, file=sys.stderr, **kwargs)

def color(text, code):
    return f"\033[{code}m{text}\033[0m"

def green(text):
    return color(text, "32")

def red(text):
    return color(text, "31")

def yellow(text):
    return color(text, "33")

def load_yaml(path):
    import yaml  # type: ignore
    with open(path, "r", encoding="utf-8") as f:
        return yaml.safe_load(f)

def dump_json(data):
    return json.dumps(data, indent=2, sort_keys=True)

def find_project_yaml(project_dir: Path):
    candidates = [
        project_dir / "project.yml",
        project_dir / "project.yaml",
    ]
    for c in candidates:
        if c.is_file():
            return c
    raise FileNotFoundError(f"No project.yml found in {project_dir}")
