import os
import sys
import platform
from pathlib import Path

from .config import get_project_root, load_project_config, load_constraints_config

def check_paths():
    root = get_project_root()
    print(f"[doctor] Project root: {root}")

    cfg = load_project_config()
    if not cfg:
        print("[doctor] WARNING: project.yml not found or empty.")

    constraints = load_constraints_config()
    if not constraints:
        print("[doctor] NOTE: .architectos/constraints.yml not found; using defaults.")
    else:
        print("[doctor] Found constraints config.")

    arch_dir = root / ".architectos"
    if not arch_dir.exists():
        print(f"[doctor] NOTE: {arch_dir} does not exist; will be created as needed.")
    else:
        print(f"[doctor] .architectos directory present.")

def check_venv():
    venv = os.getenv("VIRTUAL_ENV")
    if not venv:
        print("[doctor] WARNING: VIRTUAL_ENV is not set. You may not be running inside the expected venv.")
    else:
        print(f"[doctor] Using virtualenv: {venv}")
        vpath = Path(venv)
        if not vpath.exists():
            print("[doctor] ERROR: VIRTUAL_ENV path does not exist on disk.")
    python = sys.executable
    print(f"[doctor] Python executable: {python}")
    print(f"[doctor] Python version: {platform.python_version()}")

def check_install_root():
    install_root = os.getenv("AOS_INSTALL_ROOT")
    if install_root:
        print(f"[doctor] AOS_INSTALL_ROOT: {install_root}")
    else:
        print("[doctor] AOS_INSTALL_ROOT is not set. For system/user installs, the wrapper sets this.")

def main(argv=None):
    print("ArchitectOS Doctor (0.3.0 skeleton)")
    check_paths()
    print("")
    check_venv()
    print("")
    check_install_root()
    print("")
    print("[doctor] Checks complete. For full diagnostics, future versions will validate toolchains,")
    print("         RAG indexes, and execution domain enforcement.")

if __name__ == "__main__":
    main()
