# ArchitectOS Execution Domain Specification (SAFE / NET / UNBOUND)

Version: 0.3.0-pre

ArchitectOS operates in three execution domains: SAFE, NET, and UNBOUND.
These domains control the level of access and determinism granted to the
AI assistant and the helper scripts.

## SAFE

- Deterministic, reproducible, audit-grade behavior
- No network access
- Filesystem access limited to the project root
- Only whitelisted helper actions may be executed
- Intended for: architect, spec, refactor, diagnostic, build, local rag

## NET

- Extends SAFE with controlled network access
- Allowed to call external APIs (e.g., embeddings), download packages,
  and fetch remote metadata
- Filesystem scope still limited to project root
- Intended for: rag indexing, toolkits, builds that fetch dependencies

## UNBOUND (PFY Mode)

- Full system access, including network and arbitrary shell commands
- May ssh into hosts, run package managers, manipulate services
- All actions are logged with timestamps and commands
- Dangerous operations (e.g. rm -rf, dd, mkfs, systemctl) require
  explicit confirmation
- Intended for: live troubleshooting, devops, WordPress rescue,
  experimental "vibe coding" outside the deterministic pipeline
