# ArchitectOS Unix Layout Specification (0.3.0)

This document defines where ArchitectOS stores its components on Unix-like
systems. The layout supports both system-wide and per-user installations.

## 1. Installation Roots

ArchitectOS can be installed in two primary ways:

### System-wide install

- Install root: `/opt/architectos`
- Current version: `/opt/architectos/0.3.0`
- Symlink: `/opt/architectos/current -> /opt/architectos/0.3.0`
- Virtualenv: `/opt/architectos/venv`
- Binaries (via symlink):
  - `/usr/local/bin/aos`
  - `/usr/local/bin/aos-rag`
  - `/usr/local/bin/aos-unbound`
  - `/usr/local/bin/aos-doctor`

### Per-user install

- Install root: `$HOME/.local/share/architectos`
- Current version: `$HOME/.local/share/architectos/0.3.0`
- Symlink: `$HOME/.local/share/architectos/current -> $HOME/.local/share/architectos/0.3.0`
- Virtualenv: `$HOME/.local/share/architectos/venv`
- Binaries (via symlink):
  - `$HOME/.local/bin/aos`
  - `$HOME/.local/bin/aos-rag`
  - `$HOME/.local/bin/aos-unbound`
  - `$HOME/.local/bin/aos-doctor`

The installer is responsible for populating the chosen root, creating the
venv, and establishing the appropriate symlinks.

## 2. Configuration and State

Global (system-wide) defaults may live in:

- `/etc/architectos/constraints.yml` (optional)

Per-user configuration and state live under:

- `$HOME/.config/architectos/`  (user configuration)
- `$HOME/.architectos/`         (indexes, logs, ephemeral state)

The `.architectos` directory is also used per-project (inside each
project root) for project-specific configuration and indexes, such as:

- `<project>/.architectos/constraints.yml`
- `<project>/.architectos/rag/rag.yml`
- `<project>/.architectos/rag/index.*`

## 3. Projects

Each code project that uses ArchitectOS is self-contained:

- Project root: (user-defined)
- Project config: `project.yml`
- Project-local `.architectos` directory as described above
- Project virtualenv (optional but recommended):
  - `<project>/.venv`

The `bin/aos` script inside a project prefers the project-local `.venv`,
but can be overridden with the `AOS_VENV` environment variable.

## 4. Toolchains and Dependency Management

ArchitectOS distinguishes between:

- The **core tool venv** used to run ArchitectOS itself:
  - System-wide: `/opt/architectos/venv`
  - User-wide: `$HOME/.local/share/architectos/venv`

- **Per-project venvs** used to run project code:
  - `<project>/.venv`

Future versions may add additional toolchain directories under:

- `$HOME/.architectos/toolchains/python/`
- `$HOME/.architectos/toolchains/node/`

These will be managed by dedicated `aos` subcommands and are intended to
keep pip/npm/etc. installations organized and garbage-collectable.

## 5. Enforcement

The helper layer and Python utilities read configuration from:

1. Per-project `.architectos/constraints.yml`
2. Per-user `$HOME/.config/architectos/constraints.yml` (optional)
3. System-wide `/etc/architectos/constraints.yml` (optional)

and will refuse to operate outside the configured filesystem scope for
the current execution domain (SAFE / NET / UNBOUND). All UNBOUND actions
are logged to the configured log path.
