# ArchitectOS 0.3.0 (Skeleton)

ArchitectOS (AOS) is an AI-native build and refactor framework that connects
an LLM to real-world codebases through a deterministic, auditable helper layer.

This 0.3.0 skeleton encodes:

- Execution domains: **SAFE**, **NET**, **UNBOUND (PFY mode)**
- Mode system scaffolding (architect, spec, refactor, diagnostic, build, rag, toolkit, os_bridge)
- RAG configuration and CLI stubs
- Virtualenv/bootstrap wrapper scripts
- Constraints configuration and documentation

This is a reference implementation and spec bundle, intended as a
source-of-truth for future iterations of ArchitectOS.

## Installation (Unix skeleton)

- Per-user install:
  - `./install.sh --user`
- System-wide install (requires sudo):
  - `sudo ./install.sh --system`

After installation, you should have `aos`, `aos-rag`, `aos-unbound`, and `aos-doctor`
on your PATH (via ~/.local/bin or /usr/local/bin).

## Upgrading

After installing a version system-wide or per-user, you can upgrade by:

1. Downloading a new tarball, e.g. `architectos-0.3.1.tar.gz`
2. Running:
   - `aos-upgrade /path/to/architectos-0.3.1.tar.gz`

The upgrade helper will:
- Extract the new version under the existing install root
- Reuse or create the shared tool virtualenv
- Install Python dependencies for the new version
- Update the `current` symlink so all wrappers use the new code

## Toolchain Manager (Skeleton)

Basic toolchain commands are available via:

- `aos toolchain list`
- `aos toolchain create python NAME`
- `aos toolchain use python NAME`

These commands manage metadata for user-level toolchains under
`~/.architectos/toolchains/`. Future versions will fully manage
venv/npm creation, repair, and pruning.

## tmux Helper

A simple tmux session helper is installed as `aos-tmux`.
It will start or attach to a tmux session (default name `architectos`)
and run `aos info` in the first window for convenience.
