import os
from pathlib import Path
from typing import Any, Dict
import yaml

PROJECT_ROOT_ENV = "AOS_PROJECT_ROOT"

def get_project_root() -> Path:
    env = os.getenv(PROJECT_ROOT_ENV)
    if env:
        return Path(env).resolve()
    return Path.cwd()

def load_yaml(path: Path) -> Dict[str, Any]:
    if not path.exists():
        return {}
    with path.open("r", encoding="utf-8") as f:
        return yaml.safe_load(f) or {}

def load_project_config() -> Dict[str, Any]:
    root = get_project_root()
    return load_yaml(root / "project.yml")

def load_constraints_config() -> Dict[str, Any]:
    root = get_project_root()
    return load_yaml(root / ".architectos" / "constraints.yml")
