from dataclasses import dataclass
from typing import Dict, List, Optional


@dataclass
class Domain:
    name: str
    network: bool
    fs_scope: str
    exec_profile: str
    allow_shell: List[str]
    description: str = ""
    confirm_patterns: Optional[List[str]] = None
    log_path: Optional[str] = None


def build_domains_from_config(config: Dict) -> Dict[str, Domain]:
    out: Dict[str, Domain] = {}
    domains_cfg = config.get("domains", {})
    for name, cfg in domains_cfg.items():
        allow_shell = cfg.get("allow_shell", [])
        if allow_shell == "*" or allow_shell == ["*"]:
            allow_shell = ["*"]
        domain = Domain(
            name=name,
            network=bool(cfg.get("network", False)),
            fs_scope=str(cfg.get("fs_scope", "project")),
            exec_profile=str(cfg.get("exec_profile", "")),
            allow_shell=list(allow_shell),
            description=str(cfg.get("description", "")),
            confirm_patterns=list(cfg.get("confirm_patterns", []) or []),
            log_path=cfg.get("log_path"),
        )
        out[name] = domain
    return out
