import os
from pathlib import Path
from datetime import datetime


def append_log(log_path: str, message: str) -> None:
    path = Path(os.path.expanduser(log_path))
    path.parent.mkdir(parents=True, exist_ok=True)
    timestamp = datetime.utcnow().isoformat() + "Z"
    with path.open("a", encoding="utf-8") as f:
        f.write(f"[{timestamp}] {message}\n")
