from . import register
from .base import LLMProviderBase
import requests, os, json

@register("cohere")
class CohereProvider(LLMProviderBase):
    ENDPOINT = "https://api.cohere.com/v1/chat"

    def complete(self, messages, **kwargs):
        key = os.getenv("COHERE_API_KEY")
        if not key:
            raise RuntimeError("COHERE_API_KEY not set")
        body = {
            "model": self.cfg.model,
            "messages": messages,
            "max_tokens": kwargs.get("max_output_tokens", self.cfg.max_output_tokens),
            "temperature": kwargs.get("temperature", self.cfg.temperature),
        }
        r = requests.post(self.ENDPOINT,
                          headers={"Authorization": f"Bearer {key}"},
                          json=body, timeout=60)
        r.raise_for_status()
        data = r.json()
        return data.get("text") or data
