# ArchitectOS Unix Layout Specification (0.3.0)

This document defines where ArchitectOS stores its components on Unix-like
systems. The layout supports both system-wide and per-user installations.

## 1. Installation Roots

### System-wide install

- Install root: `/opt/architectos`
- Current version: `/opt/architectos/0.3.0`
- Symlink: `/opt/architectos/current -> /opt/architectos/0.3.0`
- Virtualenv: `/opt/architectos/venv`
- Binaries (via symlink):
  - `/usr/local/bin/aos`
  - `/usr/local/bin/aos-rag`
  - `/usr/local/bin/aos-unbound`
  - `/usr/local/bin/aos-doctor`
  - `/usr/local/bin/aos-upgrade`
  - `/usr/local/bin/aos-tmux`

### Per-user install

- Install root: `$HOME/.local/share/architectos`
- Current version: `$HOME/.local/share/architectos/0.3.0`
- Symlink: `$HOME/.local/share/architectos/current -> $HOME/.local/share/architectos/0.3.0`
- Virtualenv: `$HOME/.local/share/architectos/venv`
- Binaries (via symlink):
  - `$HOME/.local/bin/aos`
  - `$HOME/.local/bin/aos-rag`
  - `$HOME/.local/bin/aos-unbound`
  - `$HOME/.local/bin/aos-doctor`
  - `$HOME/.local/bin/aos-upgrade`
  - `$HOME/.local/bin/aos-tmux`

## 2. Configuration and State

Global (system-wide) defaults may live in:

- `/etc/architectos/constraints.yml` (optional)

Per-user configuration and state live under:

- `$HOME/.config/architectos/`  (user configuration)
- `$HOME/.architectos/`         (indexes, logs, ephemeral state)

Each project that uses ArchitectOS is self-contained and may also define:

- `<project>/.architectos/constraints.yml`
- `<project>/.architectos/rag/rag.yml`
- `<project>/.architectos/rag/index.*`

## 3. Toolchains

User-level toolchains are stored under:

- `$HOME/.architectos/toolchains/`

System-level toolchains (optional) may live under:

- `/opt/architectos/toolchains/`

These directories contain per-language and per-toolchain subdirectories
managed by the toolchain manager.
