# ArchitectOS Toolchain Manager Specification (Skeleton)

This document describes the layout and responsibilities of the
ArchitectOS toolchain manager.

## Goals

- Centralize language/runtime environments under a single directory:
  `~/.architectos/toolchains/` (user) or `/opt/architectos/toolchains/` (system).
- Track metadata and usage for each toolchain (who created it, which
  projects use it, when it was last used).
- Allow clean creation, listing, repair, and pruning of toolchains.
- Integrate with per-project configuration via `.architectos/toolchain.yml`.

## Layout

User-level toolchains:

```text
~/.architectos/toolchains/
  python/
    py311-aos-default/
    py311-django-1/
  node/
    node20-nextjs-1/
```

Each toolchain directory contains:

- `meta.json`: static metadata about the toolchain
- `status.json`: dynamic usage information (last_used, projects, health)
- `env/`: venv or language-specific environment directory

## Per-project binding

Each project may define `.architectos/toolchain.yml`, e.g.:

```yaml
python:
  toolchain_id: "python:py311-aos-default"
  fallback_to_local_venv: true

node:
  toolchain_id: "node:node20-nextjs-1"
```

ArchitectOS uses this file to select the appropriate toolchain when
running commands for that project.

## CLI surface

The `aos toolchain` subcommands include:

- `list`: show all known toolchains
- `info`: display detailed info about a single toolchain (future)
- `create`: create a new toolchain for a language (Python support first)
- `use`: bind a toolchain to the current project
- `prune`: remove unused or stale toolchains (future)
- `repair`: attempt to repair a broken toolchain (future)

This skeleton implements:

- Read-only listing and metadata scaffolding
- Python toolchain metadata and venv creation
- Binding toolchains to projects

## First-run behavior

On the first interactive run of `aos`, if no toolchains exist and the
first-run flag has not been set, a small wizard offers to create a default
Python toolchain. This may also bind the toolchain to the current project
if a `project.yml` is present. Non-interactive environments skip the wizard
by default, but can opt in via `AOS_FIRST_RUN_AUTO=1` or disable it via
`AOS_NO_WIZARD=1`.
